/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.component.statistic.aggregation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import stormy.pythian.component.statistic.aggregation.StatisticAggregator;
import stormy.pythian.component.statistic.tdigest.TDigest;
import stormy.pythian.model.instance.Instance;
import stormy.pythian.model.instance.OutputFixedFeaturesMapper;

public class AggregableQuantiles
implements StatisticAggregator.AggregableStatistic<TDigest> {
    private static final long serialVersionUID = 845845674309635484L;
    private final OutputFixedFeaturesMapper mapper;
    private final double compression;

    public AggregableQuantiles(OutputFixedFeaturesMapper mapper, double compression) {
        this.mapper = mapper;
        this.compression = compression;
    }

    @Override
    public TDigest init(Number feature) {
        TDigest quantilesState = new TDigest(this.compression);
        quantilesState.add(feature.doubleValue());
        return quantilesState;
    }

    @Override
    public TDigest combine(TDigest val1, TDigest val2) {
        if (val1 == null && val2 == null) {
            return null;
        }
        if (val1 == null) {
            return val2;
        }
        if (val2 == null) {
            return val1;
        }
        TDigest merged = TDigest.merge(this.compression, Arrays.asList(val1, val2), (Random)RandomUtils.getRandom());
        return merged;
    }

    @Override
    public TDigest zero() {
        return null;
    }

    @Override
    public Instance update(Instance original, TDigest digest) {
        HashMap<String, Double> newFeatures = new HashMap<String, Double>(6);
        newFeatures.put("Feature median", this.getQuantile(digest, 0.5));
        newFeatures.put("Feature 75th percentiles", this.getQuantile(digest, 0.75));
        newFeatures.put("Feature 90th percentiles", this.getQuantile(digest, 0.9));
        newFeatures.put("Feature 95th percentiles", this.getQuantile(digest, 0.95));
        newFeatures.put("Feature 99th percentiles", this.getQuantile(digest, 0.99));
        newFeatures.put("Feature 99.9th percentiles", this.getQuantile(digest, 0.999));
        Instance newInstance = original.withFeatures(this.mapper, newFeatures);
        return newInstance;
    }

    private Double getQuantile(TDigest digest, double q) {
        if (digest == null || digest.centroidCount() <= 1) {
            return null;
        }
        return digest.quantile(q);
    }
}

