/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.component;

import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichSpout;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichSpout;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Values;
import backtype.storm.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import storm.trident.Stream;
import storm.trident.TridentTopology;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.Function;
import storm.trident.operation.TridentCollector;
import storm.trident.state.StateFactory;
import storm.trident.tuple.TridentTuple;
import stormy.pythian.model.annotation.ComponentType;
import stormy.pythian.model.annotation.Documentation;
import stormy.pythian.model.annotation.ExpectedFeature;
import stormy.pythian.model.annotation.InputStream;
import stormy.pythian.model.annotation.Mapper;
import stormy.pythian.model.annotation.MappingType;
import stormy.pythian.model.annotation.OutputStream;
import stormy.pythian.model.annotation.Property;
import stormy.pythian.model.annotation.State;
import stormy.pythian.model.annotation.Topology;
import stormy.pythian.model.component.Component;
import stormy.pythian.model.instance.InputFixedFeaturesMapper;
import stormy.pythian.model.instance.InputUserSelectionFeaturesMapper;
import stormy.pythian.model.instance.Instance;
import stormy.pythian.model.instance.OutputFixedFeaturesMapper;
import stormy.pythian.model.instance.OutputUserSelectionFeaturesMapper;

@Documentation(name="Test", description="Use me as a test for component edition", type=ComponentType.NO_TYPE)
public class TestComponent
implements Component {
    @InputStream(name="Input 1", type=MappingType.FIXED_FEATURES, expectedFeatures={@ExpectedFeature(name="Double", type=Double.class), @ExpectedFeature(name="Integer", type=Integer.class), @ExpectedFeature(name="String", type=String.class)})
    private Stream input1;
    @Mapper(stream="Input 1")
    private InputFixedFeaturesMapper intput1Mapper;
    @InputStream(name="Input 2", type=MappingType.USER_SELECTION)
    private Stream input2;
    @Mapper(stream="Input 2")
    private InputUserSelectionFeaturesMapper intput2Mapper;
    @OutputStream(name="Output 1", from="Input 1", newFeatures={@ExpectedFeature(name="Date", type=Date.class)})
    private Stream output1;
    @Mapper(stream="Output 1")
    private OutputFixedFeaturesMapper output1Mapper;
    @OutputStream(name="Output 2", from="Input 2", newFeatures={@ExpectedFeature(name="Feature count", type=Integer.class)})
    private Stream output2;
    @Mapper(stream="Output 2")
    private OutputFixedFeaturesMapper output2Mapper;
    @OutputStream(name="Output 3", type=MappingType.USER_SELECTION)
    private Stream output3;
    @Mapper(stream="Output 3")
    private OutputUserSelectionFeaturesMapper output3Mapper;
    @Property(name="String property", description="I'm a mandatory string", mandatory=true)
    private String stringProp;
    @Property(name="Integer property", description="I'm a integer", mandatory=false)
    private Integer integerProp;
    @Property(name="Double property", description="I'm a double", mandatory=false)
    private Double doubleProp;
    @Property(name="Number property", description="I'm a number", mandatory=false)
    private Number numberProp;
    @Property(name="Boolean property", description="I'm a mandatory boolean", mandatory=true)
    private Boolean booleanProp;
    @Property(name="Enum property 1", description="I'm a enum", mandatory=false)
    private TestEnum enumProp1;
    @Property(name="Enum property 2", description="I'm a mandatory enum", mandatory=true)
    private TestEnum enumProp2;
    @State(name="Test's state")
    private StateFactory stateFactory;
    @Topology
    private TridentTopology topology;

    public void init() {
        this.output1 = this.input1.each((Function)new BaseFunction(){

            public void execute(TridentTuple tuple, TridentCollector collector) {
                Instance originalInstance = Instance.from((TridentTuple)tuple);
                Instance newInstance = originalInstance.withFeature(TestComponent.this.output1Mapper, "Date", (Object)new Date());
                collector.emit((List)new Values(new Object[]{newInstance}));
            }
        }, new Fields(new String[]{"NEW_INSTANCE_FIELD"}));
        this.output2 = this.input2.each((Function)new BaseFunction(){

            public void execute(TridentTuple tuple, TridentCollector collector) {
                Instance originalInstance = Instance.from((TridentTuple)tuple);
                Instance newInstance = originalInstance.withFeature(TestComponent.this.output2Mapper, "Feature count", (Object)TestComponent.this.output2Mapper.size());
                collector.emit((List)new Values(new Object[]{newInstance}));
            }
        }, new Fields(new String[]{"NEW_INSTANCE_FIELD"}));
        this.output3 = this.topology.newStream(RandomStringUtils.randomAlphabetic((int)6), (IRichSpout)new BaseRichSpout(){
            private SpoutOutputCollector _collector;

            public void declareOutputFields(OutputFieldsDeclarer declarer) {
                declarer.declare(new Fields(new String[]{"NEW_INSTANCE_FIELD"}));
            }

            public void open(Map conf, TopologyContext context, SpoutOutputCollector collector) {
                this._collector = collector;
            }

            public void nextTuple() {
                Utils.sleep((long)200L);
                ArrayList<Integer> features = new ArrayList<Integer>();
                for (int i = 0; i < TestComponent.this.output2Mapper.size(); ++i) {
                    features.add(i);
                }
                Instance newInstance = Instance.newInstance((OutputUserSelectionFeaturesMapper)TestComponent.this.output3Mapper, features);
                this._collector.emit((List)new Values(new Object[]{newInstance}));
            }
        });
    }

    public static enum TestEnum {
        VALUE1,
        VALUE2,
        VALUE3,
        VALUE4;

    }
}

