/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.component.statistic.tdigest;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Queues;
import java.io.Serializable;
import java.util.Deque;
import java.util.Iterator;
import stormy.pythian.component.statistic.tdigest.TDigest;

public class GroupTree
implements Iterable<TDigest.Group>,
Serializable {
    private static final long serialVersionUID = -1803298015481271285L;
    private int count;
    private int size;
    private int depth;
    private TDigest.Group leaf;
    private GroupTree left;
    private GroupTree right;

    public GroupTree() {
        this.depth = 0;
        this.size = 0;
        this.count = 0;
        this.leaf = null;
        this.right = null;
        this.left = null;
    }

    public GroupTree(TDigest.Group leaf) {
        this.depth = 1;
        this.size = 1;
        this.leaf = leaf;
        this.count = leaf.count();
        this.right = null;
        this.left = null;
    }

    public GroupTree(GroupTree left, GroupTree right) {
        this.left = left;
        this.right = right;
        this.count = left.count + right.count;
        this.size = left.size + right.size;
        this.rebalance();
        this.leaf = this.right.first();
    }

    public void add(TDigest.Group group) {
        if (this.size == 0) {
            this.leaf = group;
            this.depth = 1;
            this.count = group.count();
            this.size = 1;
            return;
        }
        if (this.size == 1) {
            int order = group.compareTo(this.leaf);
            if (order < 0) {
                this.left = new GroupTree(group);
                this.right = new GroupTree(this.leaf);
            } else if (order > 0) {
                this.left = new GroupTree(this.leaf);
                this.right = new GroupTree(group);
                this.leaf = group;
            }
        } else if (group.compareTo(this.leaf) < 0) {
            this.left.add(group);
        } else {
            this.right.add(group);
        }
        this.count += group.count();
        ++this.size;
        this.depth = Math.max(this.left.depth, this.right.depth) + 1;
        this.rebalance();
    }

    private void rebalance() {
        int r;
        int l = this.left.depth();
        if (l > (r = this.right.depth()) + 1) {
            if (this.left.left.depth() > this.left.right.depth()) {
                this.rotate(this.left.left.left, this.left.left.right, this.left.right, this.right);
            } else {
                this.rotate(this.left.left, this.left.right.left, this.left.right.right, this.right);
            }
        } else if (r > l + 1) {
            if (this.right.left.depth() > this.right.right.depth()) {
                this.rotate(this.left, this.right.left.left, this.right.left.right, this.right.right);
            } else {
                this.rotate(this.left, this.right.left, this.right.right.left, this.right.right.right);
            }
        } else {
            this.depth = Math.max(this.left.depth(), this.right.depth()) + 1;
        }
    }

    private void rotate(GroupTree a, GroupTree b, GroupTree c, GroupTree d) {
        this.left = new GroupTree(a, b);
        this.right = new GroupTree(c, d);
        this.count = this.left.count + this.right.count;
        this.size = this.left.size + this.right.size;
        this.depth = Math.max(this.left.depth(), this.right.depth()) + 1;
        this.leaf = this.right.first();
    }

    private int depth() {
        return this.depth;
    }

    public int size() {
        return this.size;
    }

    public int headCount(TDigest.Group base) {
        if (this.size == 0) {
            return 0;
        }
        if (this.left == null) {
            return this.leaf.compareTo(base) < 0 ? 1 : 0;
        }
        if (base.compareTo(this.leaf) < 0) {
            return this.left.headCount(base);
        }
        return this.left.size + this.right.headCount(base);
    }

    public int headSum(TDigest.Group base) {
        if (this.size == 0) {
            return 0;
        }
        if (this.left == null) {
            return this.leaf.compareTo(base) < 0 ? this.count : 0;
        }
        if (base.compareTo(this.leaf) <= 0) {
            return this.left.headSum(base);
        }
        return this.left.count + this.right.headSum(base);
    }

    public TDigest.Group first() {
        Preconditions.checkState((this.size > 0 ? 1 : 0) != 0, (Object)"No first element of empty set");
        if (this.left == null) {
            return this.leaf;
        }
        return this.left.first();
    }

    @Override
    public Iterator<TDigest.Group> iterator() {
        return this.iterator(null);
    }

    private Iterator<TDigest.Group> iterator(final TDigest.Group start) {
        return new AbstractIterator<TDigest.Group>(){
            Deque<GroupTree> stack = Queues.newArrayDeque();
            {
                this.push(GroupTree.this, start);
            }

            private void push(GroupTree z, TDigest.Group start2) {
                while (z.left != null) {
                    if (start2 == null || start2.compareTo(z.leaf) < 0) {
                        this.stack.push(z.right);
                        z = z.left;
                        continue;
                    }
                    z = z.right;
                }
                if (start2 == null || z.leaf.compareTo(start2) >= 0) {
                    this.stack.push(z);
                }
            }

            protected TDigest.Group computeNext() {
                GroupTree r = this.stack.poll();
                while (r != null && r.left != null) {
                    this.push(r, start);
                    r = this.stack.poll();
                }
                if (r != null) {
                    return r.leaf;
                }
                return (TDigest.Group)this.endOfData();
            }
        };
    }

    public void remove(TDigest.Group base) {
        Preconditions.checkState((this.size > 0 ? 1 : 0) != 0, (Object)"Cannot remove from empty set");
        if (this.size == 1) {
            Preconditions.checkArgument((base.compareTo(this.leaf) == 0 ? 1 : 0) != 0, (String)"Element %s not found", (Object[])new Object[]{base});
            this.size = 0;
            this.count = 0;
            this.leaf = null;
        } else if (base.compareTo(this.leaf) < 0) {
            if (this.left.size > 1) {
                this.left.remove(base);
                this.count -= base.count();
                --this.size;
                this.rebalance();
            } else {
                this.size = this.right.size;
                this.count = this.right.count;
                this.depth = this.right.depth;
                this.leaf = this.right.leaf;
                this.left = this.right.left;
                this.right = this.right.right;
            }
        } else if (this.right.size > 1) {
            this.right.remove(base);
            this.leaf = this.right.first();
            this.count -= base.count();
            --this.size;
            this.rebalance();
        } else {
            this.size = this.left.size;
            this.count = this.left.count;
            this.depth = this.left.depth;
            this.leaf = this.left.leaf;
            this.right = this.left.right;
            this.left = this.left.left;
        }
    }

    public TDigest.Group floor(TDigest.Group base) {
        if (this.size == 0) {
            return null;
        }
        if (this.size == 1) {
            return base.compareTo(this.leaf) >= 0 ? this.leaf : null;
        }
        if (base.compareTo(this.leaf) < 0) {
            return this.left.floor(base);
        }
        TDigest.Group floor = this.right.floor(base);
        if (floor == null) {
            floor = this.left.last();
        }
        return floor;
    }

    public TDigest.Group last() {
        Preconditions.checkState((this.size > 0 ? 1 : 0) != 0, (Object)"Cannot find last element of empty set");
        if (this.size == 1) {
            return this.leaf;
        }
        return this.right.last();
    }

    public TDigest.Group ceiling(TDigest.Group base) {
        if (this.size == 0) {
            return null;
        }
        if (this.size == 1) {
            return base.compareTo(this.leaf) <= 0 ? this.leaf : null;
        }
        if (base.compareTo(this.leaf) < 0) {
            TDigest.Group r = this.left.ceiling(base);
            if (r == null) {
                r = this.right.first();
            }
            return r;
        }
        return this.right.ceiling(base);
    }

    public Iterable<TDigest.Group> tailSet(final TDigest.Group start) {
        return new Iterable<TDigest.Group>(){

            @Override
            public Iterator<TDigest.Group> iterator() {
                return GroupTree.this.iterator(start);
            }
        };
    }

    public int sum() {
        return this.count;
    }

    public void checkBalance() {
        if (this.left != null) {
            Preconditions.checkState((Math.abs(this.left.depth() - this.right.depth()) < 2 ? 1 : 0) != 0, (Object)"Imbalanced");
            int l = this.left.depth();
            int r = this.right.depth();
            Preconditions.checkState((this.depth == Math.max(l, r) + 1 ? 1 : 0) != 0, (Object)"Depth doesn't match children");
            Preconditions.checkState((this.size == this.left.size + this.right.size ? 1 : 0) != 0, (Object)"Sizes don't match children");
            Preconditions.checkState((this.count == this.left.count + this.right.count ? 1 : 0) != 0, (Object)"Counts don't match children");
            Preconditions.checkState((this.leaf.compareTo(this.right.first()) == 0 ? 1 : 0) != 0, (String)"Split is wrong %.5d != %.5d or %d != %d", (Object[])new Object[]{this.leaf.mean(), this.right.first().mean(), this.leaf.id(), this.right.first().id()});
            this.left.checkBalance();
            this.right.checkBalance();
        }
    }

    public void print(int depth) {
        for (int i = 0; i < depth; ++i) {
            System.out.printf("| ", new Object[0]);
        }
        int imbalance = Math.abs((this.left != null ? this.left.depth : 1) - (this.right != null ? this.right.depth : 1));
        System.out.printf("%s%s, %d, %d, %d\n", (imbalance > 1 ? "* " : "") + (this.right != null && this.leaf.compareTo(this.right.first()) != 0 ? "+ " : ""), this.leaf, this.size, this.count, this.depth);
        if (this.left != null) {
            this.left.print(depth + 1);
            this.right.print(depth + 1);
        }
    }
}

