/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.component.statistic.aggregation;

import stormy.pythian.component.statistic.aggregation.StatisticAggregator;
import stormy.pythian.model.instance.Instance;
import stormy.pythian.model.instance.OutputFixedFeaturesMapper;

public class AggregableMean
implements StatisticAggregator.AggregableStatistic<MeanState> {
    private static final long serialVersionUID = 845845674309635484L;
    private final OutputFixedFeaturesMapper mapper;

    public AggregableMean(OutputFixedFeaturesMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public MeanState init(Number feature) {
        return new MeanState(feature.doubleValue(), 1L);
    }

    @Override
    public MeanState combine(MeanState val1, MeanState val2) {
        return new MeanState(val1.sum + val2.sum, val1.count + val2.count);
    }

    @Override
    public MeanState zero() {
        return new MeanState(0.0, 0L);
    }

    @Override
    public Instance update(Instance original, MeanState statistic) {
        return original.withFeature(this.mapper, "Feature mean", statistic == null ? null : Double.valueOf(statistic.getMean()));
    }

    public static class MeanState {
        private final double sum;
        private final long count;

        public MeanState(double sum, long count) {
            this.sum = sum;
            this.count = count;
        }

        public double getMean() {
            return this.sum / (double)this.count;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.count ^ this.count >>> 32);
            long temp = Double.doubleToLongBits(this.sum);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeanState other = (MeanState)obj;
            if (this.count != other.count) {
                return false;
            }
            return Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(other.sum);
        }

        public String toString() {
            return "MeanState [sum=" + this.sum + ", count=" + this.count + "]";
        }
    }
}

