/*
 * Decompiled with CFR 0.152.
 */
package stormy.pythian.component.statistic;

import storm.trident.Stream;
import stormy.pythian.component.statistic.aggregation.AbstractFeatureStatistic;
import stormy.pythian.component.statistic.aggregation.AggregableQuantiles;
import stormy.pythian.component.statistic.tdigest.TDigest;
import stormy.pythian.model.annotation.ComponentType;
import stormy.pythian.model.annotation.Documentation;
import stormy.pythian.model.annotation.ExpectedFeature;
import stormy.pythian.model.annotation.Mapper;
import stormy.pythian.model.annotation.OutputStream;
import stormy.pythian.model.annotation.Property;
import stormy.pythian.model.instance.OutputFixedFeaturesMapper;

@Documentation(name="Feature quantiles", type=ComponentType.ANALYTICS)
public class FeatureQuantiles
extends AbstractFeatureStatistic<TDigest> {
    private static final long serialVersionUID = 1L;
    @OutputStream(name="out", from="in", newFeatures={@ExpectedFeature(name="Feature median", type=Double.class), @ExpectedFeature(name="Feature 75th percentiles", type=Double.class), @ExpectedFeature(name="Feature 90th percentiles", type=Double.class), @ExpectedFeature(name="Feature 95th percentiles", type=Double.class), @ExpectedFeature(name="Feature 99th percentiles", type=Double.class), @ExpectedFeature(name="Feature 99.9th percentiles", type=Double.class)})
    private Stream out;
    @Mapper(stream="out")
    private OutputFixedFeaturesMapper outputMapper;
    @Property(name="Compression", description="How should accuracy be traded for size? A value of N here will give quantile errors almost always less than 3/N with considerably smaller errors expected for extreme quantiles. Conversely, you should expect to track about 5 N centroids for this accuracy.")
    private double compression = 100.0;

    public void init() {
        AggregableQuantiles aggregableStatistic = new AggregableQuantiles(this.outputMapper, this.compression);
        this.out = this.initOutputStream(aggregableStatistic);
    }
}

