(ns piotr-yuxuan.walter-ci.lein-deploy
  (:require [babashka.process :as process]
            [leiningen.deploy]
            [clojure.java.io :as io]
            [leiningen.core.project :as leiningen]))

(def github-workspace
  "/Users/p2b/src/github.com/piotr-yuxuan/walter-ci")

(defn step
  [{{:keys [github-workspace]} :env}]
  (let [deploy-repositories (-> (io/file github-workspace "project.clj")
                                (.getAbsolutePath)
                                (leiningen/read [:deploy])
                                :deploy-repositories)]
    (doseq [[deploy-repository _] deploy-repositories]
      (let [{:keys [exit]} @(process/process ["lein" "deploy" deploy-repository]
                                             {:out :inherit
                                              :dir (io/file github-workspace)})]
        (assert (zero? exit) (format "Deployment failed to %s" deploy-repository))))))
