/*
 * Decompiled with CFR 0.152.
 */
package com.sgoertzen.sonarbreak.qualitygate;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sgoertzen.sonarbreak.qualitygate.Condition;
import com.sgoertzen.sonarbreak.qualitygate.ConditionStatus;
import com.sgoertzen.sonarbreak.qualitygate.Result;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class ResultDeserializer
extends JsonDeserializer {
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Result result = new Result();
        JsonNode root = (JsonNode)jsonParser.readValueAsTree();
        JsonNode component = root.get("component");
        result.setId(this.getText(component, "id"));
        result.setKey(this.getText(component, "key"));
        result.setName(this.getText(component, "name"));
        JsonNode msr = component.get("measures");
        if (msr == null) {
            throw new IOException("Node named \"msr\" not found in JSON response.");
        }
        Iterator elements = msr.elements();
        if (elements.hasNext()) {
            String qualityGateJson = ((JsonNode)elements.next()).get("value").asText();
            ObjectMapper map2 = new ObjectMapper();
            JsonNode jsonNode = map2.readTree(qualityGateJson);
            String level = this.getText(jsonNode, "level");
            result.setStatus(ConditionStatus.forValue(level));
            List conditions = (List)map2.convertValue((Object)jsonNode.get("conditions"), (TypeReference)new TypeReference<List<Condition>>(){});
            result.setConditions(conditions);
        }
        return result;
    }

    private String getText(JsonNode node, String propertyName) {
        JsonNode childNode = node.get(propertyName);
        if (childNode == null) {
            return null;
        }
        return childNode.asText();
    }
}

