/*
 * Decompiled with CFR 0.152.
 */
package com.sgoertzen.sonarbreak.qualitygate;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.sgoertzen.sonarbreak.qualitygate.CeResponse;
import java.io.IOException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CeResponseDeserialiser
extends JsonDeserializer {
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        CeResponse response = null;
        JsonNode root = (JsonNode)jsonParser.readValueAsTree();
        JsonNode current = root.get("current");
        if (null != current) {
            response = new CeResponse();
            String dateString = current.get("executedAt").asText();
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ssZZ");
            response.setAnalysisTime(formatter.parseDateTime(dateString));
            response.setComponentKey(this.getText(current, "componentKey"));
        }
        return response;
    }

    private String getText(JsonNode node, String propertyName) {
        JsonNode childNode = node.get(propertyName);
        if (childNode == null) {
            return null;
        }
        return childNode.asText();
    }
}

