/*
 * Decompiled with CFR 0.152.
 */
package com.sgoertzen.sonarbreak;

import com.sgoertzen.sonarbreak.QueryExecutor;
import com.sgoertzen.sonarbreak.SonarBreakException;
import com.sgoertzen.sonarbreak.qualitygate.Condition;
import com.sgoertzen.sonarbreak.qualitygate.Query;
import com.sgoertzen.sonarbreak.qualitygate.Result;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="sonar-break", aggregator=true)
public class SonarBreakMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;
    private static final String CONDITION_FORMAT = "%s: %s level at %s (expected level of %s).";
    @Parameter(property="sonarServer", required=true)
    protected String sonarServer;
    @Parameter(property="sonarLookBackSeconds", defaultValue="60")
    protected String sonarLookBackSeconds;
    @Parameter(property="waitForProcessingSeconds", defaultValue="300")
    protected String waitForProcessingSeconds;
    @Parameter(property="sonar.projectKey", defaultValue="")
    protected String sonarKey;
    @Parameter(property="sonar.branch", defaultValue="")
    protected String sonarBranch;
    @Parameter(defaultValue="${mojoExecution}", required=true, readonly=true)
    private MojoExecution mojoExecution;

    protected static String buildErrorString(List<Condition> conditions) {
        StringBuilder builder = new StringBuilder();
        for (Condition condition : conditions) {
            builder.append("\n");
            String statusLine = String.format(CONDITION_FORMAT, new Object[]{condition.getStatus(), condition.getName(), condition.getActualLevel(), condition.getErrorLevel()});
            builder.append(statusLine);
        }
        return builder.toString();
    }

    public void execute() throws MojoExecutionException {
        MavenProject mavenProject = this.getMavenProject();
        if (this.shouldDelayExecution()) {
            this.getLog().info((CharSequence)"Delaying SonarQube break to the end of multi-module project");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.sonarKey)) {
            this.sonarKey = String.format("%s:%s", mavenProject.getGroupId(), mavenProject.getArtifactId());
        }
        if (!StringUtils.isEmpty((CharSequence)this.sonarBranch)) {
            this.sonarKey = String.format("%s:%s", this.sonarKey, this.sonarBranch);
        }
        String version = mavenProject.getVersion();
        this.getLog().info((CharSequence)("Querying sonar for analysis on " + this.sonarKey + ", version: " + version));
        try {
            Query query = new Query(this.sonarKey, version);
            int sonarLookBackSecondsParsed = this.parseParam(this.sonarLookBackSeconds, "sonarLookBackSeconds");
            int waitForProcessingSecondsParsed = this.parseParam(this.waitForProcessingSeconds, "waitForProcessingSeconds");
            QueryExecutor executor = new QueryExecutor(this.sonarServer, sonarLookBackSecondsParsed, waitForProcessingSecondsParsed, this.getLog());
            Result result = executor.execute(query);
            this.processResult(result);
        }
        catch (SonarBreakException | IOException e) {
            throw new MojoExecutionException("Error while running sonar break", e);
        }
    }

    private int parseParam(String value, String name) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)String.format("Parameter %s set to value of %s", name, value));
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            String message = String.format("Error while parsing the %s.  The value of %s is not an integer.", name, value);
            throw new MojoExecutionException(message, (Exception)e);
        }
    }

    private MavenProject getMavenProject() throws MojoExecutionException {
        return this.session.getTopLevelProject();
    }

    private void processResult(Result result) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Got a result of " + (Object)((Object)result.getStatus())));
        String errorString = SonarBreakMojo.buildErrorString(result.getConditions());
        switch (result.getStatus()) {
            case ERROR: {
                this.getLog().error((CharSequence)errorString);
                throw new MojoExecutionException("Build did not pass sonar tests.  " + errorString);
            }
            case WARNING: {
                this.getLog().info((CharSequence)("Build passed but warnings encountered.  " + errorString));
                break;
            }
            case OK: {
                this.getLog().info((CharSequence)"Successfully passed Sonar checks");
                break;
            }
            default: {
                throw new MojoExecutionException("Unknown result state encountered: " + (Object)((Object)result.getStatus()));
            }
        }
    }

    private boolean shouldDelayExecution() {
        return !this.isDetachedGoal() && !this.isLastProjectInReactor();
    }

    private boolean isDetachedGoal() {
        return "default-cli".equals(this.mojoExecution.getExecutionId());
    }

    private boolean isLastProjectInReactor() {
        List sortedProjects = this.session.getProjectDependencyGraph().getSortedProjects();
        MavenProject lastProject = sortedProjects.isEmpty() ? this.session.getCurrentProject() : (MavenProject)sortedProjects.get(sortedProjects.size() - 1);
        return this.session.getCurrentProject().equals((Object)lastProject);
    }
}

