/*
 * Decompiled with CFR 0.152.
 */
package com.sgoertzen.sonarbreak;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sgoertzen.sonarbreak.SonarBreakException;
import com.sgoertzen.sonarbreak.qualitygate.CeResponse;
import com.sgoertzen.sonarbreak.qualitygate.Query;
import com.sgoertzen.sonarbreak.qualitygate.Result;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class QueryExecutor {
    public static final String SONAR_FORMAT_PATH = "api/measures/component?component=%s&metricKeys=quality_gate_details";
    public static final String SONAR_ANALYSIS_TIME_PATH = "api/ce/component?component=%s";
    public static final int SONAR_CONNECTION_RETRIES = 10;
    public static final int SONAR_PROCESSING_WAIT_TIME = 10000;
    private final URL sonarURL;
    private final int sonarLookBackSeconds;
    private final int waitForProcessingSeconds;
    private final Log log;

    public QueryExecutor(String sonarServer, int sonarLookBackSeconds, int waitForProcessingSeconds, Log log) throws MalformedURLException {
        this.sonarURL = new URL(sonarServer);
        this.sonarLookBackSeconds = sonarLookBackSeconds;
        this.waitForProcessingSeconds = waitForProcessingSeconds;
        this.log = log;
    }

    public Result execute(Query query) throws SonarBreakException, IOException {
        URL analysisQueryUrl = QueryExecutor.buildUrl(this.sonarURL, query, SONAR_ANALYSIS_TIME_PATH);
        this.log.debug((CharSequence)String.format("Built a sonar query url of: %s", analysisQueryUrl.toString()));
        URL queryUrl = QueryExecutor.buildUrl(this.sonarURL, query, SONAR_FORMAT_PATH);
        this.log.debug((CharSequence)String.format("Built a sonar query url of: %s", queryUrl.toString()));
        if (!this.isURLAvailable(this.sonarURL, 10)) {
            throw new SonarBreakException(String.format("Unable to get a valid response after %d tries", 10));
        }
        return this.fetchSonarStatusWithRetries(analysisQueryUrl, queryUrl);
    }

    protected static URL buildUrl(URL sonarUrl, Query query, String path) throws MalformedURLException, IllegalArgumentException {
        if (query.getSonarKey() == null || query.getSonarKey().length() == 0) {
            throw new IllegalArgumentException("No resource specified in the Query");
        }
        String sonarPathWithResource = String.format(path, query.getSonarKey());
        return new URL(sonarUrl, sonarPathWithResource);
    }

    private Result fetchSonarStatusWithRetries(URL analysisQueryUrl, URL queryUrl) throws IOException, SonarBreakException {
        DateTime oneMinuteAgo = DateTime.now().minusSeconds(this.sonarLookBackSeconds);
        DateTime waitUntil = DateTime.now().plusSeconds(this.waitForProcessingSeconds);
        do {
            if (this.isAnalysisAvailable(analysisQueryUrl, oneMinuteAgo)) {
                Result result = this.fetchSonarStatus(queryUrl);
                if (null != result && null != result.getStatus()) {
                    return result;
                }
                this.log.debug((CharSequence)"Sleeping while waiting for sonar to process job.");
            } else {
                this.log.debug((CharSequence)String.format("Query url not available yet: %s", queryUrl));
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException result) {
                // empty catch block
            }
        } while (!waitUntil.isBeforeNow());
        String message = String.format("Timed out while waiting for Sonar.  Waited %d seconds.  This time can be extended using the \"waitForProcessingSeconds\" configuration parameter.", this.waitForProcessingSeconds);
        throw new SonarBreakException(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAnalysisAvailable(URL url, DateTime oneMinuteAgo) throws SonarBreakException, IOException {
        boolean bl;
        InputStream in = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("Accept", "application/json");
            in = connection.getInputStream();
            String response = IOUtils.toString((InputStream)in);
            CeResponse result = QueryExecutor.parseResponse(response, CeResponse.class);
            bl = null != result && oneMinuteAgo.isBefore((ReadableInstant)result.getAnalysisTime());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result fetchSonarStatus(URL queryURL) throws IOException, SonarBreakException {
        Result result;
        InputStream in = null;
        try {
            URLConnection connection = queryURL.openConnection();
            connection.setRequestProperty("Accept", "application/json");
            in = connection.getInputStream();
            String response = IOUtils.toString((InputStream)in);
            result = QueryExecutor.parseResponse(response, Result.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return result;
    }

    protected boolean isURLAvailable(URL url, int retryCount) throws IOException {
        boolean serviceFound = false;
        for (int i = 0; i < retryCount; ++i) {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            int responseCode = connection.getResponseCode();
            if (200 <= responseCode && responseCode <= 399) {
                this.log.debug((CharSequence)String.format("Got a valid response of %d from %s", responseCode, url));
                serviceFound = true;
                break;
            }
            if (i + 1 >= retryCount) continue;
            try {
                this.log.debug((CharSequence)"Sleeping while waiting for sonar to become available");
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return serviceFound;
    }

    protected static <T> T parseResponse(String response, Class<T> clazz) throws SonarBreakException {
        Object result;
        ObjectMapper mapper = new ObjectMapper();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        mapper.setDateFormat((DateFormat)df);
        try {
            result = mapper.readValue(response, clazz);
        }
        catch (IOException e) {
            String msg = String.format("Unable to parse resp into %s. Json is: %s", clazz.getName(), response);
            throw new SonarBreakException(msg, e);
        }
        return (T)result;
    }
}

