/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate6.encryptor.converters;

import java.util.Objects;
import org.jasypt.encryption.BigDecimalEncryptor;
import org.jasypt.encryption.BigIntegerEncryptor;
import org.jasypt.encryption.ByteEncryptor;
import org.jasypt.encryption.pbe.PBEBigDecimalEncryptor;
import org.jasypt.encryption.pbe.PBEBigIntegerEncryptor;
import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.hibernate6.encryptor.HibernatePBEEncryptorRegistry;

public class AttributeEncryptionProvider {
    public static final String STRING_ENCRYPTER_NAME = "encryptedString";
    public static final String CALENDER_ENCRYPTER_NAME = "encryptedCalendarAsString";
    public static final String BIG_INTEGER_ENCRYPTER_NAME = "encryptedBigInteger";
    public static final String BIG_DECIMAL_ENCRYPTER_NAME = "encryptedBigDecimal";
    public static final String BYTE_ENCRYPTER_NAME = "encryptedBinary";
    private static final AttributeEncryptionProvider instance = new AttributeEncryptionProvider();

    public static AttributeEncryptionProvider getInstance() {
        return instance;
    }

    private AttributeEncryptionProvider() {
    }

    public PBEStringEncryptor stringEncryptor() {
        HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
        PBEStringEncryptor encryptor = registry.getPBEStringEncryptor(STRING_ENCRYPTER_NAME);
        if (Objects.isNull(encryptor)) {
            throw new IllegalStateException("Encryptor encryptedStringwas not found in the Jasypt Registry.");
        }
        return encryptor;
    }

    public PBEStringEncryptor calenderEncryptor() {
        HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
        PBEStringEncryptor encryptor = registry.getPBEStringEncryptor(CALENDER_ENCRYPTER_NAME);
        if (Objects.isNull(encryptor)) {
            throw new IllegalStateException("Encryptor encryptedCalendarAsStringwas not found in the Jasypt Registry.");
        }
        return encryptor;
    }

    public BigDecimalEncryptor bigDecimalEncryptor() {
        HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
        PBEBigDecimalEncryptor encryptor = registry.getPBEBigDecimalEncryptor(BIG_DECIMAL_ENCRYPTER_NAME);
        if (Objects.isNull(encryptor)) {
            throw new IllegalStateException("Encryptor encryptedBigDecimalwas not found in the Jasypt Registry.");
        }
        return encryptor;
    }

    public BigIntegerEncryptor bigIntegerEncryptor() {
        HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
        PBEBigIntegerEncryptor encryptor = registry.getPBEBigIntegerEncryptor(BIG_INTEGER_ENCRYPTER_NAME);
        if (Objects.isNull(encryptor)) {
            throw new IllegalStateException("Encryptor encryptedBigIntegerwas not found in the Jasypt Registry.");
        }
        return encryptor;
    }

    public ByteEncryptor byteEncryptor() {
        HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
        PBEByteEncryptor encryptor = registry.getPBEByteEncryptor(BYTE_ENCRYPTER_NAME);
        if (Objects.isNull(encryptor)) {
            throw new IllegalStateException("Encryptor encryptedBinarywas not found in the Jasypt Registry.");
        }
        return encryptor;
    }
}

