/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate6.connectionprovider;

import java.util.Map;
import org.hibernate.c3p0.internal.C3P0ConnectionProvider;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate6.encryptor.HibernatePBEEncryptorRegistry;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public final class EncryptedPasswordC3P0ConnectionProvider
extends C3P0ConnectionProvider {
    private static final long serialVersionUID = 5273353009914873806L;

    public void configure(Map<String, Object> props) {
        String encryptorRegisteredName = String.valueOf(props.get("hibernate.connection.encryptor_registered_name"));
        HibernatePBEEncryptorRegistry encryptorRegistry = HibernatePBEEncryptorRegistry.getInstance();
        PBEStringEncryptor encryptor = encryptorRegistry.getPBEStringEncryptor(encryptorRegisteredName);
        if (encryptor == null) {
            throw new EncryptionInitializationException("No string encryptor registered for hibernate with name \"" + encryptorRegisteredName + "\"");
        }
        String driver = String.valueOf(props.get("hibernate.connection.driver_class"));
        String url = String.valueOf(props.get("hibernate.connection.url"));
        String user = String.valueOf(props.get("hibernate.connection.username"));
        String password = String.valueOf(props.get("hibernate.connection.password"));
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)driver)) {
            props.put("hibernate.connection.driver_class", PropertyValueEncryptionUtils.decrypt((String)driver, (StringEncryptor)encryptor));
        }
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)url)) {
            props.put("hibernate.connection.url", PropertyValueEncryptionUtils.decrypt((String)url, (StringEncryptor)encryptor));
        }
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)user)) {
            props.put("hibernate.connection.username", PropertyValueEncryptionUtils.decrypt((String)user, (StringEncryptor)encryptor));
        }
        if (PropertyValueEncryptionUtils.isEncryptedValue((String)password)) {
            props.put("hibernate.connection.password", PropertyValueEncryptionUtils.decrypt((String)password, (StringEncryptor)encryptor));
        }
        super.configure(props);
    }
}

