/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate6.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate6.encryptor.HibernatePBEEncryptorRegistry;

public final class EncryptedBinaryType
implements UserType,
ParameterizedType {
    private static final int BLOCK_SIZE = 2048;
    private static final int sqlType = -3;
    private static final int[] sqlTypes = new int[]{-3};
    private boolean initialized = false;
    private boolean useEncryptorName = false;
    private String encryptorName = null;
    private String algorithm = null;
    private String password = null;
    private Integer keyObtentionIterations = null;
    private PBEByteEncryptor encryptor = null;

    public int[] sqlTypes() {
        return (int[])sqlTypes.clone();
    }

    public int getSqlType() {
        return -2;
    }

    public Class<byte[]> returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        byte[] valueBytes = (byte[])value;
        byte[] copyBytes = new byte[valueBytes.length];
        System.arraycopy(valueBytes, 0, copyBytes, 0, valueBytes.length);
        return copyBytes;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        if (cached == null) {
            return null;
        }
        return this.deepCopy(cached);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        return (Serializable)this.deepCopy(value);
    }

    public boolean isMutable() {
        return true;
    }

    public int hashCode(Object x) throws HibernateException {
        byte[] valueBytes = (byte[])x;
        int result = 1;
        for (int i = 0; i < valueBytes.length; ++i) {
            result = result * 17 + valueBytes[i];
        }
        return result;
    }

    public Object nullSafeGet(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        return null;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original == null ? null : this.deepCopy(original);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        this.checkInitialization();
        byte[] encryptedValue = rs.getBytes(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        return this.encryptor.decrypt(encryptedValue);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        this.checkInitialization();
        if (value == null) {
            st.setNull(index, -3);
        } else {
            byte[] encryptedValue = this.encryptor.encrypt((byte[])value);
            st.setBytes(index, encryptedValue);
        }
    }

    public synchronized void setParameterValues(Properties parameters) {
        String paramEncryptorName = parameters.getProperty("encryptorRegisteredName");
        String paramAlgorithm = parameters.getProperty("algorithm");
        String paramPassword = parameters.getProperty("password");
        String paramKeyObtentionIterations = parameters.getProperty("keyObtentionIterations");
        this.useEncryptorName = false;
        if (paramEncryptorName != null) {
            if (paramAlgorithm != null || paramPassword != null || paramKeyObtentionIterations != null) {
                throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is specified, none of \"algorithm\", \"password\" or \"keyObtentionIterations\" can be specified");
            }
            this.encryptorName = paramEncryptorName;
            this.useEncryptorName = true;
        } else if (paramPassword != null) {
            this.password = paramPassword;
            if (paramAlgorithm != null) {
                this.algorithm = paramAlgorithm;
            }
            if (paramKeyObtentionIterations != null) {
                try {
                    this.keyObtentionIterations = new Integer(Integer.parseInt(paramKeyObtentionIterations));
                }
                catch (NumberFormatException e) {
                    throw new EncryptionInitializationException("Value specified for \"keyObtentionIterations\" is not a valid integer");
                }
            }
        } else {
            throw new EncryptionInitializationException("If \"encryptorRegisteredName\" is not specified, then \"password\" (and optionally \"algorithm\" and \"keyObtentionIterations\") must be specified");
        }
    }

    private synchronized void checkInitialization() {
        if (!this.initialized) {
            if (this.useEncryptorName) {
                HibernatePBEEncryptorRegistry registry = HibernatePBEEncryptorRegistry.getInstance();
                PBEByteEncryptor pbeEncryptor = registry.getPBEByteEncryptor(this.encryptorName);
                if (pbeEncryptor == null) {
                    throw new EncryptionInitializationException("No big integer encryptor registered for hibernate with name \"" + this.encryptorName + "\"");
                }
                this.encryptor = pbeEncryptor;
            } else {
                StandardPBEByteEncryptor newEncryptor = new StandardPBEByteEncryptor();
                newEncryptor.setPassword(this.password);
                if (this.algorithm != null) {
                    newEncryptor.setAlgorithm(this.algorithm);
                }
                if (this.keyObtentionIterations != null) {
                    newEncryptor.setKeyObtentionIterations(this.keyObtentionIterations.intValue());
                }
                newEncryptor.initialize();
                this.encryptor = newEncryptor;
            }
            this.initialized = true;
        }
    }
}

