/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate5.encryptor;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jasypt.encryption.pbe.PBEBigDecimalEncryptor;
import org.jasypt.encryption.pbe.PBEBigIntegerEncryptor;
import org.jasypt.encryption.pbe.PBEByteEncryptor;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.hibernate5.encryptor.HibernatePBEBigDecimalEncryptor;
import org.jasypt.hibernate5.encryptor.HibernatePBEBigIntegerEncryptor;
import org.jasypt.hibernate5.encryptor.HibernatePBEByteEncryptor;
import org.jasypt.hibernate5.encryptor.HibernatePBEStringEncryptor;
import org.jboss.logging.MDC;

public final class HibernatePBEEncryptorRegistry {
    private static final HibernatePBEEncryptorRegistry instance = new HibernatePBEEncryptorRegistry();
    public static final String TENANT_ID = "tenant.id";
    private final Map<String, Object> stringEncryptors = new HashMap<String, Object>();
    private final Map<String, Object> bigIntegerEncryptors = new HashMap<String, Object>();
    private final Map<String, Object> bigDecimalEncryptors = new HashMap<String, Object>();
    private final Map<String, Object> byteEncryptors = new HashMap<String, Object>();
    private final Map<String, Map<String, Object>> multiStringEncryptors = new HashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Object>> multiBigIntegerEncryptors = new HashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Object>> multiBigDecimalEncryptors = new HashMap<String, Map<String, Object>>();
    private final Map<String, Map<String, Object>> multiByteEncryptors = new HashMap<String, Map<String, Object>>();

    public static HibernatePBEEncryptorRegistry getInstance() {
        return instance;
    }

    private HibernatePBEEncryptorRegistry() {
    }

    public synchronized void registerPBEStringEncryptor(String registeredName, PBEStringEncryptor encryptor) {
        HibernatePBEStringEncryptor hibernateEncryptor = new HibernatePBEStringEncryptor(registeredName, encryptor);
        this.registerHibernatePBEStringEncryptor(hibernateEncryptor);
    }

    synchronized void registerHibernatePBEStringEncryptor(HibernatePBEStringEncryptor hibernateEncryptor) {
        this.stringEncryptors.put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEStringEncryptor(String name) {
        this.stringEncryptors.remove(name);
    }

    public synchronized void registerPBEStringEncryptor(String tenantId, String registeredName, PBEStringEncryptor encryptor) {
        HibernatePBEStringEncryptor hibernateEncryptor = new HibernatePBEStringEncryptor(registeredName, encryptor);
        this.registerHibernatePBEStringEncryptor(tenantId, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEStringEncryptor(String tenantId, HibernatePBEStringEncryptor hibernateEncryptor) {
        ((Map)this.multiStringEncryptors.getOrDefault(tenantId, new HashMap())).put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEStringEncryptor(String tenantId, String name) {
        if (this.multiStringEncryptors.containsKey(tenantId)) {
            this.multiStringEncryptors.get(tenantId).remove(name);
        }
    }

    public synchronized PBEStringEncryptor getPBEStringEncryptor(String registeredName) {
        String tenantId;
        String string = tenantId = Objects.nonNull(MDC.get((String)TENANT_ID)) ? MDC.get((String)TENANT_ID).toString() : null;
        if (Objects.nonNull(tenantId) && this.multiStringEncryptors.containsKey(tenantId)) {
            HibernatePBEStringEncryptor hibernateEncryptor = (HibernatePBEStringEncryptor)this.multiStringEncryptors.get(tenantId).get(registeredName);
            return Objects.isNull(hibernateEncryptor) ? null : hibernateEncryptor.getEncryptor();
        }
        HibernatePBEStringEncryptor hibernateEncryptor = (HibernatePBEStringEncryptor)this.stringEncryptors.get(registeredName);
        return Objects.isNull(hibernateEncryptor) ? null : hibernateEncryptor.getEncryptor();
    }

    public synchronized void registerPBEBigIntegerEncryptor(String registeredName, PBEBigIntegerEncryptor encryptor) {
        HibernatePBEBigIntegerEncryptor hibernateEncryptor = new HibernatePBEBigIntegerEncryptor(registeredName, encryptor);
        this.bigIntegerEncryptors.put(registeredName, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEBigIntegerEncryptor(HibernatePBEBigIntegerEncryptor hibernateEncryptor) {
        this.bigIntegerEncryptors.put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEBigIntegerEncryptor(String name) {
        this.bigIntegerEncryptors.remove(name);
    }

    public synchronized void registerPBEBigIntegerEncryptor(String tenantId, String registeredName, PBEBigIntegerEncryptor encryptor) {
        HibernatePBEBigIntegerEncryptor hibernateEncryptor = new HibernatePBEBigIntegerEncryptor(registeredName, encryptor);
        this.registerHibernatePBEBigIntegerEncryptor(tenantId, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEBigIntegerEncryptor(String tenantId, HibernatePBEBigIntegerEncryptor hibernateEncryptor) {
        ((Map)this.multiBigIntegerEncryptors.getOrDefault(tenantId, new HashMap())).put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEBigIntegerEncryptor(String tenantId, String name) {
        if (this.multiBigIntegerEncryptors.containsKey(tenantId)) {
            this.multiBigIntegerEncryptors.get(tenantId).remove(name);
        }
    }

    public synchronized PBEBigIntegerEncryptor getPBEBigIntegerEncryptor(String registeredName) {
        String tenantId;
        String string = tenantId = Objects.nonNull(MDC.get((String)TENANT_ID)) ? MDC.get((String)TENANT_ID).toString() : null;
        if (Objects.nonNull(tenantId) && this.multiBigIntegerEncryptors.containsKey(tenantId)) {
            HibernatePBEBigIntegerEncryptor hibernateEncryptor = (HibernatePBEBigIntegerEncryptor)this.multiBigIntegerEncryptors.get(tenantId).get(registeredName);
            return Objects.isNull(hibernateEncryptor) ? null : hibernateEncryptor.getEncryptor();
        }
        HibernatePBEBigIntegerEncryptor hibernateEncryptor = (HibernatePBEBigIntegerEncryptor)this.bigIntegerEncryptors.get(registeredName);
        return Objects.isNull(hibernateEncryptor) ? null : hibernateEncryptor.getEncryptor();
    }

    public synchronized void registerPBEBigDecimalEncryptor(String registeredName, PBEBigDecimalEncryptor encryptor) {
        HibernatePBEBigDecimalEncryptor hibernateEncryptor = new HibernatePBEBigDecimalEncryptor(registeredName, encryptor);
        this.bigDecimalEncryptors.put(registeredName, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEBigDecimalEncryptor(HibernatePBEBigDecimalEncryptor hibernateEncryptor) {
        this.bigDecimalEncryptors.put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEBigDecimalEncryptor(String name) {
        this.bigDecimalEncryptors.remove(name);
    }

    public synchronized void registerPBEBigDecimalEncryptor(String tenantId, String registeredName, PBEBigDecimalEncryptor encryptor) {
        HibernatePBEBigDecimalEncryptor hibernateEncryptor = new HibernatePBEBigDecimalEncryptor(registeredName, encryptor);
        this.registerHibernatePBEBigDecimalEncryptor(tenantId, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEBigDecimalEncryptor(String tenantId, HibernatePBEBigDecimalEncryptor hibernateEncryptor) {
        ((Map)this.multiBigDecimalEncryptors.getOrDefault(tenantId, new HashMap())).put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEBigDecimalEncryptor(String tenantId, String name) {
        if (this.multiBigDecimalEncryptors.containsKey(tenantId)) {
            this.multiBigDecimalEncryptors.get(tenantId).remove(name);
        }
    }

    public synchronized PBEBigDecimalEncryptor getPBEBigDecimalEncryptor(String registeredName) {
        String tenantId;
        String string = tenantId = Objects.nonNull(MDC.get((String)TENANT_ID)) ? MDC.get((String)TENANT_ID).toString() : null;
        if (Objects.nonNull(tenantId) && this.multiBigDecimalEncryptors.containsKey(tenantId)) {
            HibernatePBEBigDecimalEncryptor hibernateEncryptor = (HibernatePBEBigDecimalEncryptor)this.multiBigDecimalEncryptors.get(tenantId).get(registeredName);
            return Objects.isNull(hibernateEncryptor) ? null : hibernateEncryptor.getEncryptor();
        }
        HibernatePBEBigDecimalEncryptor hibernateEncryptor = (HibernatePBEBigDecimalEncryptor)this.bigDecimalEncryptors.get(registeredName);
        return Objects.isNull(hibernateEncryptor) ? null : hibernateEncryptor.getEncryptor();
    }

    public synchronized void registerPBEByteEncryptor(String registeredName, PBEByteEncryptor encryptor) {
        HibernatePBEByteEncryptor hibernateEncryptor = new HibernatePBEByteEncryptor(registeredName, encryptor);
        this.byteEncryptors.put(registeredName, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEByteEncryptor(HibernatePBEByteEncryptor hibernateEncryptor) {
        this.byteEncryptors.put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEByteEncryptor(String name) {
        this.byteEncryptors.remove(name);
    }

    public synchronized void registerPBEByteEncryptor(String tenantId, String registeredName, PBEByteEncryptor encryptor) {
        HibernatePBEByteEncryptor hibernateEncryptor = new HibernatePBEByteEncryptor(registeredName, encryptor);
        this.registerHibernatePBEByteEncryptor(tenantId, hibernateEncryptor);
    }

    synchronized void registerHibernatePBEByteEncryptor(String tenantId, HibernatePBEByteEncryptor hibernateEncryptor) {
        ((Map)this.multiByteEncryptors.getOrDefault(tenantId, new HashMap())).put(hibernateEncryptor.getRegisteredName(), hibernateEncryptor);
    }

    synchronized void unregisterHibernatePBEByteEncryptor(String tenantId, String name) {
        if (this.multiByteEncryptors.containsKey(tenantId)) {
            this.multiByteEncryptors.get(tenantId).remove(name);
        }
    }

    public synchronized PBEByteEncryptor getPBEByteEncryptor(String registeredName) {
        String tenantId;
        String string = tenantId = Objects.nonNull(MDC.get((String)TENANT_ID)) ? MDC.get((String)TENANT_ID).toString() : null;
        if (Objects.nonNull(tenantId) && this.multiByteEncryptors.containsKey(tenantId)) {
            HibernatePBEByteEncryptor hibernateEncryptor = (HibernatePBEByteEncryptor)this.multiByteEncryptors.get(tenantId).get(registeredName);
            return Objects.isNull(hibernateEncryptor) ? null : hibernateEncryptor.getEncryptor();
        }
        HibernatePBEByteEncryptor hibernateEncryptor = (HibernatePBEByteEncryptor)this.byteEncryptors.get(registeredName);
        return Objects.isNull(hibernateEncryptor) ? null : hibernateEncryptor.getEncryptor();
    }
}

