(ns namespaced.triples
  (:require [clojure.spec.alpha :as s]
            [namespaced.triples.predicate :as predicate]))

(defonce ^:private registry (ref {}))

(defn def
  "adds a RDF triple to if object s/conforms the predicate"
  ^{:pre [(qualified-keyword? subject-id) (qualified-keyword? predicate) (map? object)]}
  [subject-id predicate object]
  (let [attributes-kw (predicate/attributes predicate)]
    (mapv #(when-not (s/valid? % (% object))
             (throw (ex-info (format "Invalid data asserted: %s" (s/explain-str % (% object)))
                             {:namespaced.triples/predicate predicate
                              :namespaced.triples/object object}))) attributes-kw)

    (dosync
     (alter registry update subject-id merge object)
     (alter predicate/registry update-in [predicate ::predicate/subjects] conj subject-id))
    {:namespaced.triples/subject subject-id
     :namespaced.triples/predicate predicate
     :namespaced.triples/object object}))

(defn fetch
  ^{:pre [(qualified-keyword? subject) (qualified-keyword? predicate) ]}
  [subject predicate]
  (-> @registry subject (select-keys (predicate/attributes predicate))))

