(ns schema-voyager.build.standalone-html
  (:require
   [clojure.java.io :as io]
   [clojure.string :as string]))

(def db-template-placeholder 'SCHEMA_VOYAGER_DB_PLACEHOLDER)

(def template-file-name "standalone-template.html")

#_{:clj-kondo/ignore #{:clojure-lsp/unused-public-var}}
(defn fill-template
  "Creates a standalone HTML page at `output-path`, by subsitituting the `db`
  into the template file."
  [output-path db]
  (let [target-file (io/file "." output-path)
        contents    (slurp (io/resource template-file-name))
        replaced    (string/replace contents
                                    (pr-str (str db-template-placeholder))
                                    (pr-str (pr-str db)))]
    (io/make-parents target-file)
    (spit target-file replaced :append false)))
