/*
 * Decompiled with CFR 0.152.
 */
package icednrepl12480.difflib;

import icednrepl12480.difflib.Chunk;
import icednrepl12480.difflib.Delta;
import icednrepl12480.difflib.PatchFailedException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeDelta<T>
extends Delta<T> {
    public ChangeDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        int i;
        this.verify(target);
        int position = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        for (i = 0; i < size; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getRevised().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void restore(List<T> target) {
        int i;
        int position = this.getRevised().getPosition();
        int size = this.getRevised().size();
        for (i = 0; i < size; ++i) {
            target.remove(position);
        }
        i = 0;
        for (Object line : this.getOriginal().getLines()) {
            target.add(position + i, line);
            ++i;
        }
    }

    @Override
    public void verify(List<T> target) throws PatchFailedException {
        this.getOriginal().verify(target);
        if (this.getOriginal().getPosition() > target.size()) {
            throw new PatchFailedException("Incorrect patch for delta: delta original position > target size");
        }
    }

    public String toString() {
        return "[ChangeDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getOriginal().getLines() + " to " + this.getRevised().getLines() + "]";
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.CHANGE;
    }
}

