/*
 * Decompiled with CFR 0.152.
 */
package icednrepl124.difflib;

import icednrepl124.difflib.Delta;
import icednrepl124.difflib.DeltaComparator;
import icednrepl124.difflib.PatchFailedException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Patch<T> {
    private List<Delta<T>> deltas = new LinkedList<Delta<T>>();

    public List<T> applyTo(List<T> target) throws PatchFailedException {
        LinkedList<T> result = new LinkedList<T>(target);
        ListIterator<Delta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta<T> delta = it.previous();
            delta.applyTo(result);
        }
        return result;
    }

    public List<T> restore(List<T> target) {
        LinkedList<T> result = new LinkedList<T>(target);
        ListIterator<Delta<T>> it = this.getDeltas().listIterator(this.deltas.size());
        while (it.hasPrevious()) {
            Delta<T> delta = it.previous();
            delta.restore(result);
        }
        return result;
    }

    public void addDelta(Delta<T> delta) {
        this.deltas.add(delta);
    }

    public List<Delta<T>> getDeltas() {
        Collections.sort(this.deltas, DeltaComparator.INSTANCE);
        return this.deltas;
    }
}

