/*
 * Decompiled with CFR 0.152.
 */
package icednrepl1211.difflib;

import icednrepl1211.difflib.Chunk;
import icednrepl1211.difflib.Delta;
import icednrepl1211.difflib.PatchFailedException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDelta<T>
extends Delta<T> {
    public DeleteDelta(Chunk<T> original, Chunk<T> revised) {
        super(original, revised);
    }

    @Override
    public void applyTo(List<T> target) throws PatchFailedException {
        this.verify(target);
        int position2 = this.getOriginal().getPosition();
        int size = this.getOriginal().size();
        for (int i = 0; i < size; ++i) {
            target.remove(position2);
        }
    }

    @Override
    public void restore(List<T> target) {
        int position2 = this.getRevised().getPosition();
        List lines2 = this.getOriginal().getLines();
        for (int i = 0; i < lines2.size(); ++i) {
            target.add(position2 + i, lines2.get(i));
        }
    }

    @Override
    public Delta.TYPE getType() {
        return Delta.TYPE.DELETE;
    }

    @Override
    public void verify(List<T> target) throws PatchFailedException {
        this.getOriginal().verify(target);
    }

    public String toString() {
        return "[DeleteDelta, position: " + this.getOriginal().getPosition() + ", lines: " + this.getOriginal().getLines() + "]";
    }
}

