(ns telsos.lib.time
  (:require
   [telsos.lib.human-readable]
   [tick.core :as t]))

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

#?(:clj
   (defn stopwatch {:inline (fn [] `(System/nanoTime))}
     ^long []
     (System/nanoTime)))

#?(:clj
   (defn elapsed-nanosecs
     ^long [^long swatch]
     (- (System/nanoTime) swatch)))

#?(:clj
   (defn elapsed-msecs
     ^double [^long swatch]
     (/ (double (elapsed-nanosecs swatch)) 1e6)))

#?(:clj
   (defn elapstr
     ^String [^long swatch]
     (telsos.lib.human-readable/human-readable-nanosecs
       (elapsed-nanosecs swatch) #_digits 2)))

#?(:clj
   (defn catimela
     [body {:keys [msg]}]
     (let [start (stopwatch)
           value (body)
           msecs (elapsed-msecs start)
           msg   (if msg (str msg " elapsed ") "elapsed ")]

       (println (str msg  msecs " msecs"))

       value)))

(defn date->instant
  "Converts a LocalDate to Instant at midnight in the given timezone (UTC by default)."
  ([date]
   (date->instant date "UTC"))

  ([date timezone]
   (t/instant (t/in (t/at date (t/midnight)) timezone))))
