(ns telsos.lib.es.store)

(defprotocol Store
  ;; Events
  (insert-event! [store params]
    "Insert a new event.
     params: {:type :agg {:id :type :ver} :request-id :interaction-id :payload}
     Returns: {:id <UUIDv7> :created-at inst}
     Throws on (agg :type, agg :id, agg :ver) conflict.")

  (select-events-by-agg-id [store agg-type agg-id]
    "Select all events for an aggregate.
     Returns: seq of event maps, ordered by version.")

  (select-event-by-agg-version [store agg-type agg-id agg-ver]
    "Select a single event by aggregate identity and version.
     Returns: event map or nil.")

  ;; Aggregates
  (insert-agg! [store agg-type attrs]
    "Insert a new aggregate.
     Returns: {:id <UUIDv7> :valid-from inst}")

  (update-agg! [store agg-type id ver attrs]
    "Update an existing aggregate.
     Returns: {:valid-from inst} or nil if not found.")

  (select-agg-by-id [store agg-type id]
    "Select aggregate by id.
     Returns: {:id :type :ver :attrs :valid-from} or nil."))
