(ns telsos.lib.es.events
  #?(:cljs
     (:require-macros
      [telsos.lib.assertions :refer [the]]))
  (:require
   [clojure.set :as set]
   #?(:clj [telsos.lib.assertions :refer [the]])))

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

;; CONFIG
(defonce ^:private event-types-atom (atom nil))

(defn- valid-types-numeration?
  "Checks that values are exactly (1 2 3 ... n) for n entries."
  [m]
  (let [vals (set (vals m))
        n    (count m)]
    (= vals (set (range 1 (inc n))))))

(defn valid-types?
  "Checks that m is a map with keyword keys and values exactly (1 2 3 ... n)."
  [m]
  (and (map? m)
       (every? keyword? (keys m))
       (valid-types-numeration? m)))

(defn init!
  "Initializes event types. The map must have keyword keys and values
   must be exactly (1 2 3 ... n) for n entries."
  [event-types]
  (the valid-types? event-types)
  (reset! event-types-atom event-types))

(defn- get-event-types []
  (the some? @event-types-atom))

;; FACADE
(defn event-type? [x] (contains? (get-event-types) x))

(defn event-type->int
  [event-type]
  (the pos-int? (get (get-event-types) event-type -1)))

(defn int->event-type
  [id]
  (the keyword? (get (set/map-invert (get-event-types)) id)))
