(ns telsos.lib.assertions)

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

#?(:clj
   (defmacro asrt
     [& body]
     `(let [x# (do ~@body)]
        (when-not (some? x#)
          (throw (ex-info "The evaluated body is nil" {})))

        x#)))

#?(:clj
   (defmacro the
     [pred & body]
     `(let [x#    (do ~@body)
            pred# ~pred]
        (when-not (pred# x#)
          (throw (ex-info "The evaluated body doesn't match predicate"
                          {:pred-form '~pred
                           :pred      pred#
                           :value     x#})))
        x#)))

#?(:clj
   (defmacro maybe
     [pred & body]
     `(let [x# (do ~@body)]
        (when (some? x#)
          (let [pred# ~pred]
            (when-not (pred# x#)
              (throw (ex-info "The evaluated body is neither nil nor satisfies predicate"
                              {:pred-form '~pred
                               :pred      pred#
                               :value     x#}))))
          x#))))
