(ns telsos.lib.uuid
  #?(:cljs
     (:require
      ["uuidv7" :as uuidv7-lib]))
  #?(:clj
     (:import
      (com.github.f4b6a3.uuid UuidCreator))))

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

(defn uuidv7
  "Generates a UUIDv7 string.
   UUIDv7 is a time-ordered UUID that encodes Unix timestamp in milliseconds."
  []
  #?(:clj  (str (UuidCreator/getTimeOrderedEpoch))
     :cljs (uuidv7-lib/uuidv7)))
