(ns telsos.lib.es.store)

(defprotocol Store
  ;; Events
  (insert-event! [store params]
    "Insert a new event.
     params: {:event-type :agg-type :agg-id :agg-version :request-id :interaction-id :payload}
     Returns: {:id <UUIDv7> :created-at inst}
     Throws on (agg-type, agg-id, agg-version) conflict.")

  (select-events-by-agg-id [store agg-type agg-id]
    "Select all events for an aggregate.
     Returns: seq of event maps, ordered by version.")

  (select-event-by-agg-version [store agg-type agg-id agg-version]
    "Select a single event by aggregate identity and version.
     Returns: event map or nil.")

  ;; Aggregates
  (insert-agg! [store agg-type attrs]
    "Insert a new aggregate.
     Returns: {:id <UUIDv7> :valid-from inst}")

  (update-agg! [store agg-type id version attrs]
    "Update an existing aggregate.
     Returns: {:valid-from inst} or nil if not found.")

  (select-agg-by-id [store agg-type id]
    "Select aggregate by id.
     Returns: {:id :version :attrs :valid-from} or nil."))
