(ns telsos.lib.es.aggs
  #?(:cljs
     (:require-macros
      [telsos.lib.assertions :refer [the]]))
  (:require
   [clojure.set :as set]
   [telsos.lib.es.events :as events]
   #?(:clj [telsos.lib.assertions :refer [the]])))

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

;; CONFIG
(defonce ^:private agg-config-atom (atom nil))

(defn- valid-agg-table-names?
  [agg-types agg-table-names]
  (and (map? agg-table-names)
       (= (set (keys agg-types)) (set (keys agg-table-names)))
       (every? string? (vals agg-table-names))))

(defn init!
  "Initializes aggregate types and table names. The agg-types map must have
   keyword keys and values must be exactly (1 2 3 ... n) for n entries.
   The agg-table-names map must have the same keys as agg-types with string values."
  [agg-types agg-table-names]
  (the events/valid-types? agg-types)
  (the #(valid-agg-table-names? agg-types %) agg-table-names)
  (reset! agg-config-atom {:agg-types       agg-types
                           :agg-table-names agg-table-names}))

(defn- get-agg-config []
  (the some? @agg-config-atom))

(defn- get-agg-types []
  (:agg-types (get-agg-config)))

(defn- get-agg-table-names []
  (:agg-table-names (get-agg-config)))

;; FACADE
(defn agg-type? [x] (contains? (get-agg-types) x))

(defn agg-type->int
  [agg-type]
  (the pos-int? (get (get-agg-types) agg-type -1)))

(defn int->agg-type
  [id]
  (the keyword? (get (set/map-invert (get-agg-types)) id)))

(defn agg-table-name
  [agg-type]
  (the string? (get (get-agg-table-names) agg-type)))
