(ns telsos.lib.net
  (:require
   [telsos.lib.properties :refer [get-system-property]])
  (:import
   (java.net Socket)))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn port-in-use?
  [^String host ^long port]
  (try
    (Socket/.close (Socket. host port)) true
    (catch java.net.SocketException _    false)))

(defn nrepl?
  [host ^long port]
  (and (get-system-property Boolean "nrepl" {:default false})
       (port-in-use? host port)))
