(ns telsos.lib.logging
  (:require
   [clojure.tools.logging :as log]
   [telsos.lib.binding]))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(def mdc* (telsos.lib.binding/create-scoped))

(defmacro with-mdc
  [mdc & body]
  `(telsos.lib.binding/scoped [mdc* ~mdc]
     ~@body))

(defmacro log-impl
  [log-symbol & more]
  (let [more          (or (seq more) '(""))
        mdc           (gensym "mdc__")
        more-with-mdc (cons  mdc more)]

    (with-meta `(if-let [~mdc @mdc*]
                  (~log-symbol ~@more-with-mdc)
                  (~log-symbol ~@more))

      (meta &form))))

(defmacro trace [& more] (with-meta `(log-impl log/trace ~@more) (meta &form)))
(defmacro debug [& more] (with-meta `(log-impl log/debug ~@more) (meta &form)))
(defmacro info  [& more] (with-meta `(log-impl log/info  ~@more) (meta &form)))
(defmacro warn  [& more] (with-meta `(log-impl log/warn  ~@more) (meta &form)))
(defmacro error [& more] (with-meta `(log-impl log/error ~@more) (meta &form)))
(defmacro fatal [& more] (with-meta `(log-impl log/fatal ~@more) (meta &form)))
