(ns telsos.lib.properties)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(def ^:private PROPERTY-PARSER
  {String  identity
   Boolean parse-boolean
   Long    parse-long
   Double  parse-double})

(defn get-property
  ([props clazz k]
   (get-property props clazz k {}))

  ([props clazz k {:keys [default] :or {default ::undefined}}]
   (when (not= default ::undefined)
     (assert (instance? clazz default)))

   (if-let [s (java.util.Properties/.getProperty props k)]
     ((PROPERTY-PARSER clazz) s)

     (if (= default ::undefined)
       (throw
         (IllegalArgumentException. (str "Unrecognized property " k)))
       default))))

(defn get-system-property
  ([clazz k]
   (get-property (System/getProperties) clazz k))

  ([clazz k options]
   (get-property (System/getProperties) clazz k options)))
