(ns telsos.lib.io
  (:require
   [clojure.edn :as edn]
   [clojure.java.io]))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn read-resource
  [name url-processor]
  (if-let [url (clojure.java.io/resource name)]
    (url-processor url)
    (throw (ex-info "Resource not found" {:name name}))))

(defn read-resource-edn
  [name]
  (read-resource name #(-> % slurp edn/read-string)))

(defn read-resource-str
  ^String [name]
  (read-resource name slurp))
