(ns telsos.lib.control
  (:require
   [telsos.lib.assertions :refer [maybe]])
  (:import
   (telsos.lib Return)))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defmacro return-to
  {:style/indent 1}
  [label & body]
  (let [file (str *file*)
        line (long (or (-> &form meta :line) -1))]
    `(throw (Return.
              ~(cond (keyword? label) label
                     (nil?     label) nil
                     :else
                     `(maybe keyword? ~label))

              (do ~@body) ~file ~line))))

(defmacro return
  {:style/indent 1}
  [& body]
  `(return-to nil ~@body))

(defmacro returning
  {:style/indent 1}
  [& body]
  (let [label (first body)
        label (when (keyword? label) label)]

    (if (nil? label)
      ;; (returning ...) with no label catches all returns
      `(try (do ~@body)
            (catch Return r# (Return/.getValue r#)))

      `(try (do ~@body)
            (catch Return r#
              (when-not (identical? ~label (Return/.getLabel r#))
                (throw r#))

              (Return/.getValue r#))))))
