(ns telsos.lib.exceptions
  (:require
   [telsos.lib.logging]))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defmacro def-catching->action-macro
  [name action]
  (when-not (or (symbol? action) (list? action))
    (throw (ex-info "Action must be a symbol or a list" {:action action})))

  `(defmacro ~name
     ~{:arglists ''([form] [err-value form] [err-value classnames form])
       :style/indent 1}

     ([form#]            `(~'~name  nil        [java.lang.Throwable] ~form#))
     ([err-value# form#] `(~'~name ~err-value# [java.lang.Throwable] ~form#))

     ([err-value# classnames# form#]
      (let [classnames# (cond
                          (sequential? classnames#) (vec classnames#)
                          classnames# [classnames#]
                          :else [java.lang.Throwable])
            catch-clauses#
            (for [classname# classnames#]
              `(catch ~classname# ~'e# (~'~action ~'e#) ~err-value#))]

        #_{:splint/disable [lint/no-catch]}
        `(try ~form# ~@catch-clauses#)))))

(def-catching->action-macro catching->log-trace telsos.lib.logging/trace)
(def-catching->action-macro catching->log-debug telsos.lib.logging/debug)
(def-catching->action-macro catching->log-info  telsos.lib.logging/info)
(def-catching->action-macro catching->log-warn  telsos.lib.logging/warn)
(def-catching->action-macro catching->log-error telsos.lib.logging/error)
(def-catching->action-macro catching->log-fatal telsos.lib.logging/fatal)
(def-catching->action-macro catching->noop      clojure.core/identity)
(def-catching->action-macro catching->prn       clojure.core/prn)
