(ns telsos.lib.validation.cljs.macros)

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

#?(:clj
   (defmacro invalid
     ([message data]
      (let [file (str *file*)
            line (long (or (-> &form meta :line) -1))]
        `(invalid {:message ~message
                   :data    ~data
                   :file    ~file
                   :line    ~line})))

     ([{:keys [message data cause file line]}]
      (let [file (or file (str *file*))
            line (long (or line (-> &form meta :line) -1))]
        `(ex-info (str ~message)
                  {:telsos.lib.validation.cljs/validation-exception true
                   :telsos.lib.validation.cljs/file                 ~file
                   :telsos.lib.validation.cljs/line                 ~line
                   :telsos.lib.validation.cljs/data                 ~data}
                  ~cause)))))

#?(:clj
   (defmacro validating
     [& body]
     `(try
        (do ~@body)
        (catch js/Error e#
          (if (telsos.lib.validation.cljs/validation-exception? e#)
            (throw e#)
            (throw (invalid {:message (ex-message e#)
                             :data    {}
                             :cause   e#})))))))
