(ns telsos.lib.malli
  #?(:cljs
     (:require-macros
      [telsos.lib.assertions :refer [asrt]]
      [telsos.lib.validation.cljs.macros :refer [invalid]]))
  (:require
   [malli.core :as malli]
   [malli.error :as malli.error]
   [malli.transform :as malli.transform]
   #?@(:clj
       [[telsos.lib.assertions :refer [asrt]]
        [telsos.lib.validation :refer [invalid]]])))

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

(defn create-validating-decoder
  ([schema]
   (create-validating-decoder schema (malli.transform/json-transformer)))

  ([schema transformer]
   (asrt transformer)
   (let [decoder   (malli/decoder   schema transformer)
         explainer (malli/explainer schema)
         validator (malli/validator schema)]

     (fn [data]
       (let [decoded (decoder data)]
         (if (validator decoded)
           decoded

           (throw (invalid "Decoded data validation failed"
                           {:data    data
                            :decoded decoded

                            :explanation
                            ;; Force before logging. Invalid exceptions are lighweight (in
                            ;; Clojure, not ClojureScript), so in order to avoid excessive
                            ;; explanations, we deliberately delay them.
                            (delay (malli.error/humanize (explainer decoded)))}))))))))

(defn create-validating-encoder
  ([schema]
   (create-validating-encoder schema (malli.transform/json-transformer)))

  ([schema transformer]
   (asrt transformer)
   (let [encoder   (malli/encoder schema transformer)
         explainer (malli/explainer schema)
         validator (malli/validator schema)]

     (fn [data]
       (when-not (validator data)
         (throw (ex-info "Data validation failed"
                         {:data        data
                          :explanation (malli.error/humanize (explainer data))})))

       (encoder data)))))
