(ns telsos.lib.jvm
  (:require
   [clojure.string :as str]
   [telsos.lib.human-readable :refer [human-readable-bytes]])
  (:import
   (java.lang.management ManagementFactory RuntimeMXBean)))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn room
  []
  (let [rt     (Runtime/getRuntime)
        free   (Runtime/.freeMemory  rt)
        total  (Runtime/.totalMemory rt)
        mx     (Runtime/.maxMemory   rt)
        used   (- total free)
        digits 2]

    (println
      "Used:"  (human-readable-bytes used  digits) "|"
      "Free:"  (human-readable-bytes free  digits) "|"
      "Total:" (human-readable-bytes total digits) "|"
      "Max:"   (human-readable-bytes mx    digits))))

(defn gc
  ([] (gc {:verbose? true}))

  ([{:keys [verbose?]}]
   (System/gc)
   (when verbose? (room))))

(defn jvm-args
  ([]
   (let [bean (ManagementFactory/getRuntimeMXBean)]
     (seq (RuntimeMXBean/.getInputArguments bean))))

  ([starting-with]
   (filter (fn [arg] (some #(str/starts-with? arg %) starting-with))
           (jvm-args))))
