(ns telsos.lib.binding
  (:import
   (java.lang ScopedValue ScopedValue$Carrier)))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defonce ^:private fake-nil (Object.))

(defprotocol ^:private IScopedAccess
  (get-scoped-value [this]))

(deftype ^:private Scoped [scoped-value default-value]
  Object
  (toString [this] (str (deref this)))

  IScopedAccess
  (get-scoped-value [_] scoped-value)

  clojure.lang.IDeref
  (deref [_]
    (let [other (if (some? default-value) default-value fake-nil)
          value (ScopedValue/.orElse scoped-value other)]
      (when-not (identical? fake-nil value)
        value))))

(defn create-scoped
  ([]
   (create-scoped #_default-value nil))

  ([default-value]
   (Scoped. (ScopedValue/newInstance) default-value)))

(defn scoped*
  [scoped value body]
  (ScopedValue$Carrier/.call (ScopedValue/where (Scoped/.get-scoped-value scoped) value) body))

(defmacro scoped {:style/indent 1}
  [[scoped- value] & body]
  `(scoped* ~scoped- ~value (fn [& ~'_] ~@body)))
