(ns telsos.lib.flags
  #?(:clj
     (:require
      [clojure.string :as str])))

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

(defn flag*
  [k not-k non-k no-k is-not-k isnt-k are-not-k arent-k x]
  (cond
    ;; Truth
    (or (true?                x)
        (identical? k         x))
    true

    ;; Falsity
    (or (false?               x)
        (nil?                 x)
        (identical? not-k     x)
        (identical? non-k     x)
        (identical? no-k      x)
        (identical? is-not-k  x)
        (identical? isnt-k    x)
        (identical? are-not-k x)
        (identical? arent-k   x))
    false

    :else
    (throw (ex-info "Illegal flag value" {:value x}))))

#?(:clj
   (defmacro flag
     [s]
     (assert           (symbol?    s))
     (assert (not      (namespace  s)))
     (assert (str/ends-with? (name s) "?"))

     (let [s1 (str/join (butlast (name s)))]
       (assert (not= "" s1) "Flag symbol should be more than just a sole '?'")
       `(flag*
          ~(keyword s1)
          ~(keyword (str "not-"     s1))
          ~(keyword (str "non-"     s1))
          ~(keyword (str "no-"      s1))
          ~(keyword (str "is-not-"  s1))
          ~(keyword (str "isnt-"    s1))
          ~(keyword (str "are-not-" s1))
          ~(keyword (str "arent-"   s1))
          ~s))))
