(ns telsos.lib.validation)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defmacro invalid
  ([message data]
   `(invalid {:message           ~message
              :data              ~data
              :with-stack-trace? false}))

  ([{:keys [message data cause with-stack-trace?]}]
   (let [file (str *file*)
         line (long (or (-> &form meta :line) -1))]

     `(telsos.lib.ValidationException.
        (str ~message)
        ~cause
        (boolean ~with-stack-trace?)
        ~file
        ~line
        ~data))))

(defmacro validating
  [& body]
  `(try (do ~@body)
        (catch telsos.lib.ValidationException e# (throw e#))
        (catch java.lang.Exception e#
          ;; In rare cases catching Exception and wrapping it into ValidationException
          ;; may be hiding problems in the system unrelated to invalid data, so use with
          ;; care and don't broaden the scope of the macro beyond what's necessary.
          (throw (invalid {:message           (Exception/.getMessage e#)
                           :data              {}
                           :cause             e#
                           :with-stack-trace? false})))))
