(ns telsos.lib.math
  #?(:clj
     (:require
      [clojure.math :as math]
      [clojure.math.numeric-tower])))

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

#?(:clj
   (defn ** [base pow]
     (clojure.math.numeric-tower/expt base pow)))

(defn long-even? [n] (zero? (bit-and (long n) 1)))
(defn long-odd?  [n] (not   (long-even? n)))

(defn mean
  [xs]
  (or (when (seq xs) (/ (double (reduce + xs)) (count xs)))

      ;; for empties
      0))

(defn median ;; Thanks https://rosettacode.org/wiki/Averages/Median#Clojure
  [xs]
  (when (seq xs) ;; for empties undefined
    (let [xs  (sort  xs)
          c1  (count xs)
          mid (bit-shift-right c1 1)]

      (if (odd? c1)
        (nth xs mid)

        (mean [(nth xs mid) (nth xs (dec mid))])))))

#?(:clj
   (defn effectively-int?
     [x]
     (cond
       (int? x) true

       (or (double? x) (float? x))
       (let [d (double x)] (= d (math/rint d)))

       :else false)))

#?(:clj
   (defn effectively-nat-int?
     [x]
     (and (effectively-int? x) (not (neg? (long x))))))

#?(:clj
   (defn effectively-pos-int?
     [x]
     (and (effectively-int? x) (pos? (long x)))))
