(ns telsos.lib.clojure)

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

(defn ns? [x]
  #?(:clj  (instance? clojure.lang.Namespace x)
     :cljs (instance? cljs.core.Namespace    x)))

#?(:clj
   (defn RT-var
     (^clojure.lang.Var
       [ns- name-]
       (clojure.lang.RT/var ns- name-))

     (^clojure.lang.Var
       [ns- name- file]
       (let [v1 (RT-var ns- name-)]
         (if-not (instance? clojure.lang.Var$Unbound @v1)
           v1

           (do (load-file file) (RT-var ns- name-)))))))

(defn named? [x]
  #?(:clj  (or (string? x) (instance? clojure.lang.Named x))
     :cljs (or (string? x) (keyword? x) (symbol? x))))

(defn maybe-name [x]
  (when (named? x)
    (name x)))
