(ns telsos.lib.assertions)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defmacro asrt
  [& body]
  `(let [x# (do ~@body)]
     (assert x#) x#))

(defmacro asrts
  [& xs]
  `(do ~@(map (fn [x] `(asrt ~x)) xs)))

(defmacro the
  [pred & body]
  `(let [x# (do ~@body)]
     (assert (~pred x#))
     x#))

(defmacro maybe
  [pred & body]
  `(let [x# (do ~@body)]
     (assert (or (nil? x#) (~pred x#)))
     x#))
