(ns telsos.lib.strings
  #?(:clj
     (:refer-clojure :exclude [parse-long]))
  #?(:cljs
     (:require
      [clojure.string :as str]
      [goog.string :as gstring]
      [goog.string.format]))
  #?(:clj
     (:import
      (org.apache.commons.validator.routines EmailValidator)
      (telsos.lib Numbers))))

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

(defn non-blank?
  [s]
  (and s (not #?(:clj  (.isBlank ^String s)
                 :cljs (str/blank?       s)))))

#?(:cljs
   (defn format [fmt & args]
     (apply gstring/format fmt args)))

#?(:clj
   (defn email?
     ([s]
      (.isValid (EmailValidator/getInstance) s))

     ([allow-local? allow-tld? s]
      (.isValid (EmailValidator/getInstance allow-local? allow-tld?) s))))

#?(:clj
   (def Email
     [:fn {:error/message "should be a valid email"} email?]))

(defn indent-string
  ([length]
   (indent-string length " "))

  ([length with]
   ;; .repeat also works for cljs
   (str (.repeat (str with) (long length)))))

(defn indent-for-length
  ([s length]
   (indent-for-length s length " "))

  ([s length with]
   (let [s    (str s)
         diff (- (long length) (.length s))]
     (if (pos? diff)
       (str (indent-string diff with) s)
       s))))

#?(:clj
   (defn parse-long
     ^Long [s]
     (when s (Numbers/parseLong s))))
