(ns telsos.lib.algorithms.maps
  #?(:clj
     (:import
      (clojure.lang IPersistentMap))))

#?(:clj (set! *warn-on-reflection*       true))
#?(:clj (set! *unchecked-math* :warn-on-boxed))

(defn invert-map->multimap
  [m]
  (loop [result  (transient {})
         entries (seq m)]
    (if-not entries
      (persistent! result)

      (let [e (first entries)
            k (key e)
            v (val e)]

        (recur (if-let [s (result v)]
                 (assoc! result v (conj s k))
                 (assoc! result v #{k}))

               (next entries))))))

(defn submap?
  "Returns true if m2 is a submap of m1, false otherwise. A map is considered a submap if
  all of its key-value pairs exist in the other map. It also works for vectors, treating
  them as maps with non-negative integral keys."
  [m1 m2]
  (every? (fn [[k v]] (= (get m1 k ::n0t-f0und) v)) m2))

(defn mcount ^long
  [m]
  (or (when-not m 0)
      #?(:clj  (.count ^IPersistentMap m)
         :cljs (count m))))

(defn mempty?
  [m]
  (zero? (mcount m)))

(defn mmerge-2
  [m1 m2]
  #?(:clj  (.cons ^IPersistentMap m1 m2)
     :cljs (merge                 m1 m2)))

(defn mmerge
  ([] nil)
  ([m]  m)
  ([m1 m2]
   (cond (mempty? m1) m2
         (mempty? m2) m1
         :else        (mmerge-2 m1 m2)))

  ([m1 m2 & maps]
   (if-not maps
     (mmerge m1 m2)
     (reduce mmerge (mmerge m1 m2) maps))))

(defn m=
  ([m]
   (assert (map? m)) true)

  ([m1 m2]
   #?(:clj  (.equals ^IPersistentMap m1 ^IPersistentMap m2)
      :cljs (= m1 m2)))

  ([m1 m2 & more]
   (if (m= m1 m2)
     (if (next more)
       (recur m2 (first more) (next more))
       (m= m2 (first more)))

     false)))
