(ns telsos.lib.strings
  (:refer-clojure :exclude [parse-long])
  (:import
   (org.apache.commons.validator.routines EmailValidator)
   (telsos.lib Numbers)))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn non-blank?
  [^String s]
  (and s (not (.isBlank s))))

(defn email?
  ([s]
   (and s (.isValid (EmailValidator/getInstance) s)))

  ([allow-local? allow-tld? s]
   (and s (.isValid (EmailValidator/getInstance allow-local? allow-tld?) s))))

(def Email
  [:fn {:error/message "should be a valid email"} email?])

(defn indent-string
  (^String [length]
    (indent-string length " "))

  (^String [length with]
    (str (.repeat (str with) (long length)))))

(defn indent-for-length
  (^String [s ^long length]
    (indent-for-length s length " "))

  (^String [s ^long length with]
    (let [s    (str s)
          diff (- length (.length s))]
      (if (pos? diff)
        (str (indent-string diff with) s)
        s))))

(defn parse-long
  ^Long [s]
  (when s (Numbers/parseLong s)))
