(ns telsos.lib.capture-arguments)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(def ^:private captured-arguments-atom (atom {}))

(defn captured-arguments
  [id]
  (get @captured-arguments-atom id))

(defn capture-arguments!
  [id f & args]
  (swap! captured-arguments-atom assoc id args)
  (apply f args))

(defn apply-arguments
  [id f]
  (apply f (captured-arguments id)))
