(ns telsos.lib.math.kleene)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(def  unknown ::unknown)
(defn unknown? [x] (identical? x unknown))

(defmacro And
  ([] true)
  ([x]   x)
  ([x & xs]
   `(let [x# ~x]
      (if (unknown? x#)
        (if-not (And ~@xs) false unknown)
        (if-not  x# x# (And ~@xs))))))

(defmacro Or
  ([] false)
  ([x]    x)
  ([x  & xs]
   `(let [x# ~x]
      (if (unknown? x#)
        (let [y# (Or ~@xs)]
          (if (or (unknown? y#) (not y#))
            unknown
            y#))

        (or x# (Or ~@xs))))))

(defn Not
  [x]
  (if (unknown? x) unknown (not x)))
