(ns telsos.lib.algorithms.paip)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

;; BREADTH-FIRST WALKS AND SEARCH
(defn breadth-first-tree-levels
  [start adjs]
  (->> [start] (iterate #(mapcat adjs %)) (take-while seq)))

(defn breadth-first-tree-seq
  ([start adjs]
   (apply concat (breadth-first-tree-levels start adjs)))

  ([start adjs depth]
   (->>
     (breadth-first-tree-levels start adjs)
     (take   depth)
     (apply concat))))

(defn breadth-first-search
  ([start adjs goal?]
   (first (filter goal? (breadth-first-tree-seq start adjs))))

  ([start adjs goal? depth]
   (first (filter goal? (breadth-first-tree-seq start adjs depth)))))

;; TREE SEARCH ROUTINES FROM BY PAIP, CHAPTER 6.4
(defn flip-2 [f]
  (fn [x y] (f y x)))

(defn lazy-cat-2 [xs ys]
  (lazy-cat xs ys))

(def depth-first-combiner      (flip-2     concat))
(def lazy-depth-first-combiner (flip-2 lazy-cat-2))

(defn tree-search
  [start adjs goal? comb]
  (loop [nodes (list start)]
    (when (seq nodes)
      (let [obj (first nodes)]
        (if (goal? obj)
          obj
          (recur (comb (rest nodes) (adjs obj))))))))

(defn depth-first-search
  [start adjs goal?]
  (tree-search start adjs goal? depth-first-combiner))
