(ns telsos.lib.flags
  (:require
   [clojure.string :as str]))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn flag*
  [k not-k non-k no-k is-not-k isnt-k are-not-k arent-k x]
  (cond
    ;; Truth
    (true?                x) true
    (identical? k         x) true

    ;; Falsity
    (false?               x) false
    (nil?                 x) false
    (identical? not-k     x) false
    (identical? non-k     x) false
    (identical? no-k      x) false
    (identical? is-not-k  x) false
    (identical? isnt-k    x) false
    (identical? are-not-k x) false
    (identical? arent-k   x) false

    :else
    (throw (ex-info "Illegal flag value" {:value x}))))

(defmacro flag
  [s]
  (assert           (symbol?    s))
  (assert (not      (namespace  s)))
  (assert (str/ends-with? (name s) "?"))

  (let [s1 (str/join (butlast (name s)))]
    (assert (not= "" s1) "Flag symbol should be more than just a sole '?'")
    `(flag*
       ~(keyword s1)
       ~(keyword (str "not-"     s1))
       ~(keyword (str "non-"     s1))
       ~(keyword (str "no-"      s1))
       ~(keyword (str "is-not-"  s1))
       ~(keyword (str "isnt-"    s1))
       ~(keyword (str "are-not-" s1))
       ~(keyword (str "arent-"   s1))
       ~s)))
