(ns telsos.lib.algorithms.maps)

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn invert-map->multimap
  [m]
  (loop [result  (transient {})
         entries (seq m)]
    (if-not entries
      (persistent! result)

      (let [e (first entries)
            k (key e)
            v (val e)]

        (recur (if-let [s (result v)]
                 (assoc! result v (conj s k))
                 (assoc! result v #{k})) (next entries))))))

(defn submap?
  "Returns true if m2 is a submap of m1, false otherwise. A map is considered a submap if
  all of its key-value pairs exist in the other map. It also works for vectors, treating
  them as maps with non-negative integral keys."
  [m1 m2]
  (every? (fn [[k v]] (= (get m1 k ::n0t-f0und) v)) m2))
