(ns telsos.lib.jvm
  (:require
   [clojure.string :as str]
   [telsos.lib.human-readable :as human-readable]))

(set! *warn-on-reflection*       true)
(set! *unchecked-math* :warn-on-boxed)

(defn room
  []
  (let [rt     (.. Runtime getRuntime)
        free   (.freeMemory        rt)
        total  (.totalMemory       rt)
        mx     (.maxMemory         rt)
        used   (- total free)
        digits 2]

    (println
      "Used:"  (human-readable/human-readable-bytes used  digits) "|"
      "Free:"  (human-readable/human-readable-bytes free  digits) "|"
      "Total:" (human-readable/human-readable-bytes total digits) "|"
      "Max:"   (human-readable/human-readable-bytes mx    digits))))

(defn gc
  ([] (gc {:verbose? true}))

  ([{:keys [verbose?]}]
   (System/gc)
   (when verbose? (room))))

(defn jvm-args
  ([]
   (seq (.. java.lang.management.ManagementFactory
            getRuntimeMXBean
            getInputArguments)))

  ([starting-with]
   (filter (fn [^String arg]
             (some #(str/starts-with? arg %) starting-with))
           (jvm-args))))
